IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES
			 WHERE TABLE_NAME='EST_MOV_MOTOQ_PDV_VD')
begin
	DROP TABLE EST_MOV_MOTOQ_PENDENTE;
	DROP TABLE EST_MOV_MOTOQ_PDV_VD;
	DROP TABLE EST_MOV_MOTOQ;
end
GO
IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES
			 WHERE TABLE_NAME='EST_MOV_MOTOQ')
begin
CREATE TABLE [dbo].[EST_MOV_MOTOQ](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_MOV] [int] NOT NULL,
	[CD_ENTREGADOR] [int] NOT NULL,
	[CD_CX] [int] NOT NULL,
	[NR_ECF] [int] NOT NULL,
	[DT_SAIDA] [datetime] NOT NULL,
	[DT_RETORNO] [datetime] NULL,
	[DT_HR_VENDA] [datetime] NOT NULL,
	[DT_ORC] [datetime] NULL,
	[DT_ALT_ATU] [datetime] NULL,
	[VERSAO_APLIC] [varchar](50) NULL,
	[NR_ORC] [int] NULL,
	[VLR_LIQ_VD] [money] NOT NULL,
	[DT_VD] [datetime] NOT NULL,
 CONSTRAINT [PK_EST_MOV_MOTOQ_1] PRIMARY KEY CLUSTERED 
(
	[CD_MOV] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_MOV_MOTOQ] ADD  CONSTRAINT [DF_EST_MOV_MOTOQ_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_MOV_MOTOQ] ADD  CONSTRAINT [DF_EST_MOV_MOTOQ_DT_SAIDA]  DEFAULT (getdate()) FOR [DT_SAIDA]

ALTER TABLE [dbo].[EST_MOV_MOTOQ] ADD  CONSTRAINT [DF_EST_MOV_MOTOQ_DT_ORC]  DEFAULT ((0)) FOR [DT_ORC]

ALTER TABLE [dbo].[EST_MOV_MOTOQ] ADD  CONSTRAINT [DF_EST_MOV_MOTOQ_VERSAO_APLIC]  DEFAULT ((0)) FOR [VERSAO_APLIC]

ALTER TABLE [dbo].[EST_MOV_MOTOQ] ADD  CONSTRAINT [DF_EST_MOV_MOTOQ_NR_ORC]  DEFAULT ((0)) FOR [NR_ORC]

ALTER TABLE [dbo].[EST_MOV_MOTOQ] ADD  CONSTRAINT [DF_EST_MOV_MOTOQ_VLR_LIQ_VD]  DEFAULT ((0)) FOR [VLR_LIQ_VD]

ALTER TABLE [dbo].[EST_MOV_MOTOQ]  WITH CHECK ADD  CONSTRAINT [FK_EST_MOV_MOTOQ_TELE_ENTREGADOR] FOREIGN KEY([CD_ENTREGADOR])
REFERENCES [dbo].[TELE_ENTREGADOR] ([CD_ENTREGADOR])

ALTER TABLE [dbo].[EST_MOV_MOTOQ] CHECK CONSTRAINT [FK_EST_MOV_MOTOQ_TELE_ENTREGADOR]
END